<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

    <head>
        <meta charset="utf-8">
        <meta content="width=device-width, initial-scale=1.0" name="viewport">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">

        <meta
            content="BD Adventure Tour is the ideal travel booking system for launching a tour and travel agency. With customizable themes, multi-language support, integrated payments, and a user-friendly booking system, it helps entrepreneurs quickly build and grow their business in the travel industry"
            name="description">
        <meta
            content="BD Adventure Tour, Travel booking system, Tour booking platform, Start a travel agency, Viator clone system, Travel business solution, Tour agency software, Online travel booking system, Travel booking website, Multi-language tour booking system, Tour management system, Travel agency system Codecanyon, Responsive travel booking platform, Find and book city tours, helicopter tours, day trips, show tickets, sightseeing day tours, popular activities and things to do in hundreds of destinations worldwide"
            name="keywords">
        <meta name="theme-color" content="">
        <meta name="author" content="BD Adventure Tour">
        <meta name="robots" content="index,follow">

        <meta property="og:type" content="website">
        <meta property="og:site_name" content="BD Adventure Tour">
        <meta property="og:title" content="BD Adventure Tour  A Complete Agency Based Tour and Travel Booking Platform">
        <meta property="og:description"
            content="BD Adventure Tour is the ideal travel booking system for launching a tour and travel agency. With customizable themes, multi-language support, integrated payments, and a user-friendly booking system, it helps entrepreneurs quickly build and grow their business in the travel industry">
        <meta property="og:image" content="{{asset('frontend/images/og/og.webp')}}">

        <meta name="twitter:card" content="BD Adventure Tour  A Complete Agency Based Tour and Travel Booking Platform">
        <meta name="twitter:title"
            content="BD Adventure Tour  A Complete Agency Based Tour and Travel Booking Platform">
        <meta name="twitter:description"
            content="BD Adventure Tour is the ideal travel booking system for launching a tour and travel agency. With customizable themes, multi-language support, integrated payments, and a user-friendly booking system, it helps entrepreneurs quickly build and grow their business in the travel industry">
        <meta name="twitter:image" content="{{asset('frontend/images/og/og.webp')}}">

        <meta name="csrf-token" content="{{csrf_token()}}">

        <title> BD Adventure Tour | A Complete Agency Based Tour and Travel Booking Platform </title>

        <link href="{{asset('favicon.ico')}}" rel="icon">
        <link href="{{asset('favicon.png')}}" rel="apple-touch-icon">

        <link rel="stylesheet" href="{{asset('frontend/css/bootstrap.min.css')}}">
        <link rel="stylesheet" href="{{asset('frontend/css/all.min.css')}}">
        <link rel="stylesheet" href="{{asset('frontend/css/fontawesome.min.css')}}">
        <link href="{{asset('frontend/css/style.css')}}" rel="stylesheet">

        @stack('style')

        <script>
            // var root = document.querySelector(':root');
            // root.style.setProperty('--praimary-color', '#2F855A');
            // root.style.setProperty('--secondary-color', '#38A169');
        </script>
    </head>

    <body>
        <div class="page-wrapper">
            <x-frontend.global.preloader />
            <x-frontend.global.navigation />
            @yield('content')
            <x-frontend.global.footer />

            <div class="prgoress_indicator">
                <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
                    <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
                </svg>
                <i class="fa-duotone fa-arrow-up"></i>
            </div>
        </div>


        <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i
                class="bi bi-arrow-up-short"></i></a>

        <x-frontend.global.cookie />

        <script src="{{asset('frontend/js/jquery-3.6.1.min.js')}}"></script>
        <script src="{{asset('frontend/js/bootstrap.bundle.min.js')}}"></script>
        <script src="{{asset('frontend/js/appear.js')}}"></script>
        <script src="{{asset('frontend/js/wow.js')}}"></script>
        <script src="{{asset('frontend/js/TweenMax.min.js')}}"></script>
        <script src="{{asset('frontend/js/odometer.min.js')}}"></script>
        <script src="{{asset('frontend/js/parallax-scroll.js')}}"></script>
        <script src="{{asset('frontend/js/jarallax.min.js')}}"></script>
        <script src="{{asset('frontend/js/jquery.paroller.min.js')}}"></script>
        <script src="{{asset('frontend/js/notiflix-aio-3.2.6.min.js')}}"></script>
        <script src="{{asset('frontend/js/script.js')}}"></script>
        @stack('script')
    </body>

</html>
